<div class="row g-3">

    {{-- Name --}}
    <div class="col-md-6">
        <label class="form-label">Service Name *</label>
        <input type="text"
               name="name"
               class="form-control @error('name') is-invalid @enderror"
               value="{{ old('name', $service->name ?? '') }}">
        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
    </div>

    {{-- Category --}}
    <div class="col-md-6">
        <label class="form-label">Category</label>
        <select name="category_id" class="form-select">
            <option value="">-- Select --</option>
            @foreach($categories as $category)
                <option value="{{ $category->id }}"
                    @selected(old('category_id', $service->category_id ?? '') == $category->id)>
                    {{ $category->name }}
                </option>
            @endforeach
        </select>
    </div>

    {{-- Company --}}
    <div class="col-md-6">
        <label class="form-label">Company</label>
        <select name="company_id" class="form-select">
            <option value="">-- Select --</option>
            @foreach($companies as $company)
                <option value="{{ $company->id }}"
                    @selected(old('company_id', $service->company_id ?? '') == $company->id)>
                    {{ $company->name }}
                </option>
            @endforeach
        </select>
    </div>

    {{-- Parent --}}
    <div class="col-md-6">
        <label class="form-label">Parent Service</label>
        <select name="parent_id" class="form-select">
            <option value="">-- None --</option>
            @foreach($parents as $parent)
                <option value="{{ $parent->id }}"
                    @selected(old('parent_id', $service->parent_id ?? '') == $parent->id)>
                    {{ $parent->name }}
                </option>
            @endforeach
        </select>
    </div>

    {{-- Short Description --}}
    <div class="col-12">
        <label class="form-label">Short Description</label>
        <input type="text"
               name="short_description"
               class="form-control"
               value="{{ old('short_description', $service->short_description ?? '') }}">
    </div>

    {{-- Description --}}
    <div class="col-12">
        <label class="form-label">Description</label>
        <textarea name="description"
                  rows="4"
                  class="form-control">{{ old('description', $service->description ?? '') }}</textarea>
    </div>

    {{-- Images --}}
    <div class="col-md-4">
        <label class="form-label">Icon</label>
        <input type="file" name="icon" class="form-control">
    </div>

    <div class="col-md-4">
        <label class="form-label">Image</label>
        <input type="file" name="image" class="form-control">
    </div>

    <div class="col-md-4">
        <label class="form-label">Banner</label>
        <input type="file" name="banner" class="form-control">
    </div>

    {{-- Status --}}
    <div class="col-md-3">
        <label class="form-label">Status</label>
        <select name="status" class="form-select">
            <option value="1" @selected(old('status', $service->status ?? 1) == 1)>Active</option>
            <option value="0" @selected(old('status', $service->status ?? 1) == 0)>Inactive</option>
        </select>
    </div>

    {{-- Order --}}
    <div class="col-md-3">
        <label class="form-label">Order</label>
        <input type="number"
               name="order"
               class="form-control"
               value="{{ old('order', $service->order ?? 0) }}">
    </div>

</div>
