@extends('layouts.app')

@section('title', 'Services')

@section('content')
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid mb-3">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Services</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator">
                            <i class="icon-arrow-right"></i>
                        </li>
                        <li class="nav-item">
                            <a href="#">Services</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">
                @can('services.create')
                    <a href="{{ route('admin.services.create') }}" class="btn btn-sm btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Add Service
                    </a>
                @endcan
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="servicesTable" class="table table-striped table-hover display">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Company</th>
                                <th>Category</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Company</th>
                                <th>Category</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($services as $service)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $service->name }}</td>
                                    <td>{{ $service->company?->name ?? '—' }}</td>
                                    <td>{{ $service->category?->name ?? '—' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $service->status ? 'success' : 'secondary' }}">
                                            {{ $service->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>{{ $service->order ?? '-' }}</td>
                                    <td class="d-flex gap-1">
                                        @can('services.edit')
                                            <a href="{{ route('admin.services.edit', $service) }}" class="btn btn-sm btn-warning">
                                                Edit
                                            </a>
                                        @endcan
                                        @can('services.delete')
                                            <form action="{{ route('admin.services.destroy', $service) }}" method="POST" onsubmit="return confirm('Are you sure?');">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">No services found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $("#servicesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([1,2,3,4]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) {
                        // Strip HTML if present
                        var text = d.replace(/<[^>]*>/g, '');
                        select.append('<option value="'+text+'">'+text+'</option>');
                    }
                });
            });
        }
    });
});
</script>
@endsection
