@extends('layouts.app')

@section('content')
<div class="container">
    <div class="page-inner">
        <div class="container">
            <div class="row row-demo-grid">
                <div class="col-md-8">
                    <div class="page-header">
                        <h3 class="fw-bold mb-3">Add User</h3>
                        <ul class="breadcrumbs mb-3">
                            <li class="nav-home">
                                <a href="{{ route('dashboard') }}">
                                    <i class="icon-home"></i>
                                </a>
                            </li>
                            <li class="separator"><i class="icon-arrow-right"></i></li>
                            <li class="nav-item">
                                <a href="{{ route('admin.users.index') }}">Users</a>
                            </li>
                            <li class="separator"><i class="icon-arrow-right"></i></li>
                            <li class="nav-item">Add User</li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-4 ms-auto">
                    @can('users.view')
                        <a href="{{ route('admin.users.index') }}" class="btn btn-sm btn-primary mb-3">Users</a>
                    @endcan
                    @can('roles.view')
                        <a href="{{ route('admin.roles.index') }}" class="btn btn-sm btn-secondary mb-3">Roles</a>
                    @endcan
                    @can('permissions.view')
                        <a href="{{ route('admin.permissions.index') }}" class="btn btn-sm btn-secondary mb-3">Permissions</a>
                    @endcan
                </div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.users.store') }}" method="POST">
                @csrf

                {{-- Name --}}
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                </div>

                {{-- Email --}}
                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" value="{{ old('email') }}" required>
                </div>

                {{-- Password --}}
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" required>
                </div>

                {{-- Confirm Password --}}
                <div class="mb-3">
                    <label class="form-label">Confirm Password</label>
                    <input type="password" name="password_confirmation" class="form-control" required>
                </div>

                {{-- Company --}}
                @can('users.change-company')
                <div class="mb-3">
                    <label class="form-label">Company</label>
                    <select name="company_id" class="form-control">
                        <option value="">— No Company —</option>
                        @foreach($companies as $company)
                            <option value="{{ $company->id }}"
                                {{ old('company_id') == $company->id ? 'selected' : '' }}>
                                {{ $company->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                @endcan

                {{-- Reports To --}}
                @can('users.change-reports-to')
                <div class="mb-3">
                    <label class="form-label">Reports To</label>
                    <select name="reports_to_user_id" class="form-control">
                        <option value="">— None —</option>
                        @foreach($users as $reportUser)
                            <option value="{{ $reportUser->id }}"
                                {{ old('reports_to_user_id') == $reportUser->id ? 'selected' : '' }}>
                                {{ $reportUser->name }} ({{ $reportUser->email }})
                            </option>
                        @endforeach
                    </select>
                    <small class="text-muted">Select the manager this user reports to.</small>
                </div>
                @endcan

                {{-- Roles --}}
                <div class="mb-3">
                    <label class="form-label">Roles</label>
                    <select name="roles[]" class="form-control" multiple required>
                        @foreach($roles as $role)
                            <option value="{{ $role }}"
                                {{ in_array($role, old('roles', [])) ? 'selected' : '' }}>
                                {{ $role }}
                            </option>
                        @endforeach
                    </select>
                    <small class="text-muted">Hold Ctrl (Windows) / Cmd (Mac) to select multiple roles.</small>
                </div>

                {{-- Actions --}}
                <button type="submit" class="btn btn-success">Create User</button>
                <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection
