@extends('layouts.app')

@section('title', 'Users')

@section('content')
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Users</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="{{ route('dashboard') }}">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Users</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                @can('users.create')
                    <a href="{{ route('admin.users.create') }}" class="btn btn-sm btn-primary mb-3">Add User</a>
                @endcan
                @can('roles.view')
                    <a href="{{ route('admin.roles.index') }}" class="btn btn-sm btn-secondary mb-3">Roles</a>
                @endcan
                @can('permissions.view')
                    <a href="{{ route('admin.permissions.index') }}" class="btn btn-sm btn-secondary mb-3">Permissions</a>
                @endcan
            </div>
        </div>

        @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="multi-filter-select" class="display table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Company</th>
                                <th>Reports To</th>
                                <th>Roles</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Company</th>
                                <th>Reports To</th>
                                <th>Roles</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            @forelse($users as $user)
                            <tr>
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->email }}</td>
                                <td>{{ $user->profile->company->name ?? '—' }}</td>
                                <td>{{ $user->profile->reportsTo->name ?? '—' }}</td>
                                <td>{{ implode(', ', $user->getRoleNames()->toArray()) }}</td>
                                <td>
                                    @can('users.edit')
                                        <a href="{{ route('admin.users.edit', $user) }}" class="btn btn-sm btn-warning">Edit</a>
                                    @endcan
                                    @can('users.delete')
                                        <form action="{{ route('admin.users.destroy', $user) }}" method="POST" style="display:inline-block">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this user?')">Delete</button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">No users found.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function () {
    $("#multi-filter-select").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([0, 1, 2, 3]).every(function () {
                var column = this;
                var select = $('<select class="form-select"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on("change", function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? "^" + val + "$" : "", true, false).draw();
                    });
                column.data().unique().sort().each(function (d) {
                    if (d) select.append('<option value="' + d + '">' + d + '</option>');
                });
            });
        }
    });
});
</script>
@endsection
