<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\PropertyDeveloperController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\ScheduleController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\LeadStageController;
use App\Http\Controllers\LeadController;

// Public welcome page
Route::get('/', fn() => view('welcome'));

// Auth routes (Breeze)
require __DIR__.'/auth.php';

/*
|--------------------------------------------------------------------------
| Protected Routes
|--------------------------------------------------------------------------
*/
Route::middleware('auth')->group(function () {

    // Profile routes
    Route::prefix('profile')->name('profile.')->group(function () {
        Route::get('/', [ProfileController::class, 'show'])->name('show');
        Route::get('/edit', [ProfileController::class, 'edit'])->name('edit');
        Route::patch('/', [ProfileController::class, 'update'])->name('update');
        Route::delete('/', [ProfileController::class, 'destroy'])->name('destroy');
    });

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])
        ->name('dashboard')
        ->middleware('permission:view dashboard');

    /*
    |--------------------------------------------------------------------------
    | Admin Routes
    |--------------------------------------------------------------------------
    */
    Route::prefix('admin')->name('admin.')->group(function () {

        // ================= USERS =================
        Route::get('users', [UserController::class, 'index'])
            ->name('users.index')
            ->middleware('permission:users.view');

        Route::get('users/create', [UserController::class, 'create'])
            ->name('users.create')
            ->middleware('permission:users.create');

        Route::post('users', [UserController::class, 'store'])
            ->name('users.store')
            ->middleware('permission:users.create');

        Route::get('users/{user}/edit', [UserController::class, 'edit'])
            ->name('users.edit')
            ->middleware('permission:users.edit');

        Route::put('users/{user}', [UserController::class, 'update'])
            ->name('users.update')
            ->middleware('permission:users.edit');

        Route::delete('users/{user}', [UserController::class, 'destroy'])
            ->name('users.destroy')
            ->middleware('permission:users.delete');


        // ================= ROLES =================
        Route::get('roles', [RoleController::class, 'index'])
            ->name('roles.index')
            ->middleware('permission:roles.view');

        Route::get('roles/create', [RoleController::class, 'create'])
            ->name('roles.create')
            ->middleware('permission:roles.create');

        Route::post('roles', [RoleController::class, 'store'])
            ->name('roles.store')
            ->middleware('permission:roles.create');

        Route::get('roles/{role}/edit', [RoleController::class, 'edit'])
            ->name('roles.edit')
            ->middleware('permission:roles.edit');

        Route::put('roles/{role}', [RoleController::class, 'update'])
            ->name('roles.update')
            ->middleware('permission:roles.edit');

        Route::delete('roles/{role}', [RoleController::class, 'destroy'])
            ->name('roles.destroy')
            ->middleware('permission:roles.delete');

        // ---- Role → Permissions mapping
        Route::get('roles/{role}/permissions', [RoleController::class, 'permissions'])
            ->name('roles.permissions')
            ->middleware('permission:roles.view');

        Route::post('roles/{role}/permissions', [RoleController::class, 'updatePermissions'])
            ->name('roles.permissions.update')
            ->middleware('permission:roles.edit');


        // ================= PERMISSIONS =================
        Route::get('permissions', [PermissionController::class, 'index'])
            ->name('permissions.index')
            ->middleware('permission:permissions.view');

        Route::get('permissions/create', [PermissionController::class, 'create'])
            ->name('permissions.create')
            ->middleware('permission:permissions.create');

        Route::post('permissions', [PermissionController::class, 'store'])
            ->name('permissions.store')
            ->middleware('permission:permissions.create');

        Route::get('permissions/{permission}/edit', [PermissionController::class, 'edit'])
            ->name('permissions.edit')
            ->middleware('permission:permissions.edit');

        Route::put('permissions/{permission}', [PermissionController::class, 'update'])
            ->name('permissions.update')
            ->middleware('permission:permissions.edit');

        Route::delete('permissions/{permission}', [PermissionController::class, 'destroy'])
            ->name('permissions.destroy')
            ->middleware('permission:permissions.delete');
        // ---------------- CATEGORIES ----------------
        Route::get('/categories', [CategoryController::class, 'index'])
            ->name('categories.index')->middleware('permission:categories.view');

        Route::get('/categories/create', [CategoryController::class, 'create'])
            ->name('categories.create')->middleware('permission:categories.create');

        Route::post('/categories', [CategoryController::class, 'store'])
            ->name('categories.store')->middleware('permission:categories.create');

        Route::get('/categories/{category}/edit', [CategoryController::class, 'edit'])
            ->name('categories.edit')->middleware('permission:categories.edit');

        Route::put('/categories/{category}', [CategoryController::class, 'update'])
            ->name('categories.update')->middleware('permission:categories.edit');

        Route::delete('/categories/{category}', [CategoryController::class, 'destroy'])
            ->name('categories.destroy')->middleware('permission:categories.delete');

        // ---------------- COMPANIES ----------------
        Route::get('/companies', [CompanyController::class, 'index'])
            ->name('companies.index')->middleware('permission:companies.view');

        Route::get('/companies/create', [CompanyController::class, 'create'])
            ->name('companies.create')->middleware('permission:companies.create');

        Route::post('/companies', [CompanyController::class, 'store'])
            ->name('companies.store')->middleware('permission:companies.create');

        Route::get('/companies/{company}/edit', [CompanyController::class, 'edit'])
            ->name('companies.edit')->middleware('permission:companies.edit');

        Route::put('/companies/{company}', [CompanyController::class, 'update'])
            ->name('companies.update')->middleware('permission:companies.edit');

        Route::delete('/companies/{company}', [CompanyController::class, 'destroy'])
            ->name('companies.destroy')->middleware('permission:companies.delete');

        // ---------------- SERVICES ----------------
        Route::get('/services', [ServiceController::class, 'index'])
            ->name('services.index')->middleware('permission:services.view');

        Route::get('/services/create', [ServiceController::class, 'create'])
            ->name('services.create')->middleware('permission:services.create');

        Route::post('/services', [ServiceController::class, 'store'])
            ->name('services.store')->middleware('permission:services.create');

        Route::get('/services/{service}/edit', [ServiceController::class, 'edit'])
            ->name('services.edit')->middleware('permission:services.edit');

        Route::put('/services/{service}', [ServiceController::class, 'update'])
            ->name('services.update')->middleware('permission:services.edit');

        Route::delete('/services/{service}', [ServiceController::class, 'destroy'])
            ->name('services.destroy')->middleware('permission:services.delete');


        // Property Developers Routes
        Route::get('/property-developers', [PropertyDeveloperController::class, 'index'])
            ->name('property_developers.index')
            ->middleware('permission:property_developers.view');

        Route::get('/property-developers/create', [PropertyDeveloperController::class, 'create'])
            ->name('property_developers.create')
            ->middleware('permission:property_developers.create');

        Route::post('/property-developers', [PropertyDeveloperController::class, 'store'])
            ->name('property_developers.store')
            ->middleware('permission:property_developers.create');

        Route::get('/property-developers/{propertyDeveloper}/edit', [PropertyDeveloperController::class, 'edit'])
            ->name('property_developers.edit')
            ->middleware('permission:property_developers.edit');

        Route::put('/property-developers/{propertyDeveloper}', [PropertyDeveloperController::class, 'update'])
            ->name('property_developers.update')
            ->middleware('permission:property_developers.edit');

        Route::delete('/property-developers/{propertyDeveloper}', [PropertyDeveloperController::class, 'destroy'])
            ->name('property_developers.destroy')
            ->middleware('permission:property_developers.delete');

        Route::get('/property-developers/{propertyDeveloper}', [PropertyDeveloperController::class, 'show'])
            ->name('property_developers.show')
            ->middleware('permission:property_developers.view');

        // Locations Routes
        Route::get('/locations', [LocationController::class, 'index'])
            ->name('locations.index')
            ->middleware('permission:locations.view');

        Route::get('/locations/create', [LocationController::class, 'create'])
            ->name('locations.create')
            ->middleware('permission:locations.create');

        Route::post('/locations', [LocationController::class, 'store'])
            ->name('locations.store')
            ->middleware('permission:locations.create');

        Route::get('/locations/{location}/edit', [LocationController::class, 'edit'])
            ->name('locations.edit')
            ->middleware('permission:locations.edit');

        Route::put('/locations/{location}', [LocationController::class, 'update'])
            ->name('locations.update')
            ->middleware('permission:locations.edit');

        Route::delete('/locations/{location}', [LocationController::class, 'destroy'])
            ->name('locations.destroy')
            ->middleware('permission:locations.delete');

        // Schedules Routes
        Route::get('schedules', [ScheduleController::class, 'index'])
            ->name('schedules.index')
            ->middleware('permission:schedules.view.all|schedules.view.own');

        Route::get('/schedules/calendar', [ScheduleController::class, 'calendar'])
            ->name('schedules.calendar')
            ->middleware('permission:schedules.view.all|schedules.view.own');

        Route::get('/schedules/create', [ScheduleController::class, 'create'])
            ->name('schedules.create')
            ->middleware('permission:schedules.create');

        Route::post('/schedules', [ScheduleController::class, 'store'])
            ->name('schedules.store')
            ->middleware('permission:schedules.create');

        Route::get('/schedules/{schedule}/edit', [ScheduleController::class, 'edit'])
            ->name('schedules.edit')
            ->middleware('permission:schedules.edit');

        Route::put('/schedules/{schedule}', [ScheduleController::class, 'update'])
            ->name('schedules.update')
            ->middleware('permission:schedules.edit');

        Route::delete('/schedules/{schedule}', [ScheduleController::class, 'destroy'])
            ->name('schedules.destroy')
            ->middleware('permission:schedules.delete');

        Route::get('/schedules/{schedule}', [ScheduleController::class, 'show'])
            ->name('schedules.show')
            ->middleware('permission:schedules.view');

        //booking routes
        Route::get('/bookings', [BookingController::class, 'index'])
            ->name('bookings.index')
            ->middleware('permission:bookings.view.all|bookings.view.own');

        Route::get('/bookings/create', [BookingController::class, 'create'])
            ->name('bookings.create')
            ->middleware('permission:bookings.create');

        Route::post('/bookings', [BookingController::class, 'store'])
            ->name('bookings.store')
            ->middleware('permission:bookings.create');

        Route::get('/bookings/{booking}/edit', [BookingController::class, 'edit'])
            ->name('bookings.edit')
            ->middleware('permission:bookings.edit');

        Route::put('/bookings/{booking}', [BookingController::class, 'update'])
            ->name('bookings.update')
            ->middleware('permission:bookings.edit');

        Route::delete('/bookings/{booking}', [BookingController::class, 'destroy'])
            ->name('bookings.destroy')
            ->middleware('permission:bookings.delete');

        Route::get('/bookings/{booking}', [BookingController::class, 'show'])
            ->name('bookings.show')
            ->middleware('permission:bookings.view');

        // Lead Stages Routes
        Route::get('/lead-stages', [App\Http\Controllers\LeadStageController::class, 'index'])
            ->name('lead-stages.index')
            ->middleware('permission:leadstages.view.all|leadstages.view.company');

        Route::get('/lead-stages/create', [App\Http\Controllers\LeadStageController::class, 'create'])
            ->name('lead-stages.create')
            ->middleware('permission:leadstages.create');
        Route::post('/lead-stages', [App\Http\Controllers\LeadStageController::class, 'store'])
            ->name('lead-stages.store')
            ->middleware('permission:leadstages.create');
        Route::get('/lead-stages/{leadStage}/edit', [App\Http\Controllers\LeadStageController::class, 'edit'])
            ->name('lead-stages.edit')
            ->middleware('permission:leadstages.edit');
        Route::put('/lead-stages/{leadStage}', [App\Http\Controllers\LeadStageController::class, 'update'])
            ->name('lead-stages.update')
            ->middleware('permission:leadstages.edit');
        Route::delete('/lead-stages/{leadStage}', [App\Http\Controllers\LeadStageController::class, 'destroy'])
            ->name('lead-stages.destroy')
            ->middleware('permission:leadstages.delete');

        // pipelines Routes
        Route::get('/pipelines', [App\Http\Controllers\PipelineController::class, 'index'])
            ->name('pipelines.index')
            ->middleware('permission:pipelines.view');
        Route::get('/pipelines/create', [App\Http\Controllers\PipelineController::class, 'create'])
            ->name('pipelines.create')
            ->middleware('permission:pipelines.create');
        Route::post('/pipelines', [App\Http\Controllers\PipelineController::class, 'store'])
            ->name('pipelines.store')
            ->middleware('permission:pipelines.create');
        Route::get('/pipelines/{pipeline}/edit', [App\Http\Controllers\PipelineController::class, 'edit'])
            ->name('pipelines.edit')
            ->middleware('permission:pipelines.edit');
        Route::put('/pipelines/{pipeline}', [App\Http\Controllers\PipelineController::class, 'update'])
            ->name('pipelines.update')
            ->middleware('permission:pipelines.edit');
        Route::delete('/pipelines/{pipeline}', [App\Http\Controllers\PipelineController::class, 'destroy'])
            ->name('pipelines.destroy')
            ->middleware('permission:pipelines.delete');
        

        // Leads Routes
        Route::prefix('leads')->name('leads.')->group(function () {

            Route::get('/', [App\Http\Controllers\LeadController::class, 'index'])
                ->name('index')
                ->middleware('permission:leads.view.all|leads.view.own');

            Route::get('/create', [App\Http\Controllers\LeadController::class, 'create'])
                ->name('create')
                ->middleware('permission:leads.create');

            Route::post('/', [App\Http\Controllers\LeadController::class, 'store'])
                ->name('store')
                ->middleware('permission:leads.create');

            Route::get('/{lead}/edit', [App\Http\Controllers\LeadController::class, 'edit'])
                ->name('edit')
                ->middleware('permission:leads.edit');

            Route::put('/{lead}', [App\Http\Controllers\LeadController::class, 'update'])
                ->name('update')
                ->middleware('permission:leads.edit');

            Route::delete('/{lead}', [App\Http\Controllers\LeadController::class, 'destroy'])
                ->name('destroy')
                ->middleware('permission:leads.delete');

            Route::get('/{lead}', [App\Http\Controllers\LeadController::class, 'show'])
                ->name('show')
                ->middleware('permission:leads.view');

            // Bulk actions
            Route::post('/bulk-delete', [App\Http\Controllers\LeadController::class, 'bulkDelete'])
                ->name('bulk-delete')
                ->middleware('permission:leads.delete');

            Route::post('/bulk-stage-update', [App\Http\Controllers\LeadController::class, 'bulkStageUpdate'])
                ->name('bulk-stage-update')
                ->middleware('permission:leads.edit');

            Route::post('/bulk-user-update', [App\Http\Controllers\LeadController::class, 'bulkUserUpdate'])
                ->name('bulk-user-update')
                ->middleware('permission:leads.edit'); // or create a separate 'leads.change_user' permission
        });
    });
});
