<?php $__env->startSection('title', 'Schedule Calendar'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Schedule Calendar</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('admin.schedules.index')); ?>"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Schedule Calendar</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.create')): ?>
                    <a href="<?php echo e(route('admin.schedules.create')); ?>" class="btn btn-sm btn-primary mb-3">
                        Add Schedule
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <div id="scheduleCalendar"></div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    const calendarEl = document.getElementById('scheduleCalendar');

    const events = [
        <?php $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                id: "<?php echo e($schedule->id); ?>-morning",
                title: "<?php echo e($schedule->user->name ?? 'Schedule'); ?> (Morning)",
                start: "<?php echo e(\Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d')); ?>T<?php echo e(\Carbon\Carbon::parse($schedule->morning_start_time)->format('H:i:s')); ?>",
                end: "<?php echo e(\Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d')); ?>T<?php echo e(\Carbon\Carbon::parse($schedule->morning_end_time)->format('H:i:s')); ?>",
                url: "<?php echo e(route('admin.schedules.show', $schedule->id)); ?>", // Navigate to show page
                backgroundColor: '#0d6efd', // Bootstrap primary color
                borderColor: '#0d6efd',
                extendedProps: {
                    location: "<?php echo e($schedule->morning_location); ?>",
                    fees: "<?php echo e($schedule->fees); ?>"
                }
            }
            <?php if($schedule->evening_start_time): ?>,
            {
                id: "<?php echo e($schedule->id); ?>-evening",
                title: "<?php echo e($schedule->user->name ?? 'Schedule'); ?> (Evening)",
                start: "<?php echo e(\Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d')); ?>T<?php echo e(\Carbon\Carbon::parse($schedule->evening_start_time)->format('H:i:s')); ?>",
                end: "<?php echo e(\Carbon\Carbon::parse($schedule->schedule_date)->format('Y-m-d')); ?>T<?php echo e(\Carbon\Carbon::parse($schedule->evening_end_time)->format('H:i:s')); ?>",
                url: "<?php echo e(route('admin.schedules.show', $schedule->id)); ?>", // Navigate to show page
                backgroundColor: '#0d6efd', // Bootstrap primary color
                borderColor: '#0d6efd',
                extendedProps: {
                    location: "<?php echo e($schedule->evening_location); ?>",
                    fees: "<?php echo e($schedule->fees); ?>"
                }
            }
            <?php endif; ?>
            <?php if(!$loop->last): ?>,<?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    ];

    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        height: 650,
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        events: events,
        navLinks: true,
        editable: false,
        selectable: false
    });

    calendar.render();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/schedules/calendar.blade.php ENDPATH**/ ?>