<?php $__env->startSection('title', 'Bookings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="page-inner">

        <div class="row mb-3">
            <div class="col-md-8">
                <h3 class="fw-bold">Bookings</h3>
            </div>
            <div class="col-md-4 text-end">
                <a href="<?php echo e(route('admin.bookings.create')); ?>" class="btn btn-primary btn-sm mb-3">
                    <i class="bi bi-plus-circle"></i> Add Booking
                </a>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body table-responsive">
                <table id="bookingsTable" class="table table-striped table-hover display">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Slot</th>
                            <th>User</th>
                            <th>Stage</th>
                            <th>Status</th>
                            <th width="150">Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th>Customer</th>
                            <th></th>
                            <th>Slot</th>
                            <th>User</th>
                            <th>Stage</th>
                            <th>Status</th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($booking->customer_name); ?></td>
                                <td><?php echo e($booking->customer_phone); ?></td>
                                <td>
                                    <?php echo e($booking->slot->shift ?? '-'); ?><br>
                                    <?php echo e($booking->slot->start_time ?? '-'); ?> - <?php echo e($booking->slot->end_time ?? '-'); ?><br>
                                    <?php echo e($booking->slot->location ?? '-'); ?>

                                </td>
                                <td><?php echo e($booking->user->name ?? '-'); ?></td>
                                <td><?php echo e(ucfirst($booking->stage)); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($booking->status == 'pending' ? 'secondary' : ($booking->status == 'confirmed' ? 'success' : ($booking->status == 'cancelled' ? 'danger' : 'info'))); ?>">
                                        <?php echo e(ucfirst($booking->status)); ?>

                                    </span>
                                </td>
                                <td class="d-flex gap-1">
                                    <a href="<?php echo e(route('admin.bookings.show', $booking)); ?>" class="btn btn-info btn-sm">View</a>
                                    <a href="<?php echo e(route('admin.bookings.edit', $booking)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                    <form action="<?php echo e(route('admin.bookings.destroy', $booking)); ?>" method="POST" onsubmit="return confirm('Cancel this booking?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-danger btn-sm">Cancel</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted">No bookings found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="mt-3">
            <?php echo e($bookings->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $("#bookingsTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            // Multi-column filter for Customer, Slot, Stage, Status
            this.api().columns([1,3,5,6]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^'+val+'$' : '', true, false).draw();
                    });
                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/bookings/index.blade.php ENDPATH**/ ?>