<?php $__env->startSection('content'); ?>
<div class="container mt-4">
   <div class="profile-header text-center position-relative">
      
      <?php if($user->profile->banner): ?>
      <div class="banner mb-5">
         <img src="<?php echo e(asset('storage/' . $user->profile->banner)); ?>" 
            alt="Banner" class="img-fluid w-100 rounded-top" style="height:200px; object-fit:cover;">
      </div>
      <?php else: ?>
      <div class="banner mb-5 bg-secondary rounded-top" style="height:200px;"></div>
      <?php endif; ?>
   </div>
   
   <div class="row justify-content-center mb-4">
      <div class="col-md-8">
         <div class="row py-3 align-items-center">
            <div class="col-md-3">
               
               <div>
                  <?php if($user->profile->avatar): ?>
                  <img src="<?php echo e(asset('storage/' . $user->profile->avatar)); ?>" 
                     alt="Avatar" class="avatar-img rounded-circle p-3" >
                  <?php else: ?>
                  <div class="rounded-circle bg-light border border-white d-flex align-items-center justify-content-center w-100 h-100" style="width:120px; height:120px;"
                     >
                     <i class="fas fa-user fa-2x text-muted"></i>
                  </div>
                  <?php endif; ?>
               </div>
            </div>
            <div class="col-md-7">
               
               <div class="">
                  <h3 class="fw-bold"><?php echo e($user->name); ?></h3>
                  <p class="text-muted mb-2"><?php echo e($user->profile->position ?? '—'); ?> <?php if($user->profile->department): ?> | <?php echo e($user->profile->department); ?> <?php endif; ?></p>
                  <p class="bio"><?php echo e($user->profile->about ?? '—'); ?></p>
               </div>
            </div>
            <div class="col-md-2">
               
               <div class="text-center ">
                  <a href="<?php echo e(route('profile.edit')); ?>" class="btn btn-primary btn-sm">Edit Profile</a>
               </div>
            </div>
         </div>
         <div class="card shadow-sm">
            <div class="card-body">
               <div class="row ">
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Email</strong>
                     <p><?php echo e($user->email); ?></p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Company</strong>
                     <p><?php echo e($user->profile->company->name ?? '—'); ?></p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Reports To</strong>
                     <p><?php echo e($user->profile->reportsTo->name ?? '—'); ?></p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Phone</strong>
                     <p><?php echo e($user->profile->phone ?? '—'); ?></p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Website</strong>
                     <p>
                        <?php if($user->profile->website): ?>
                        <a href="<?php echo e($user->profile->website); ?>" target="_blank"><?php echo e($user->profile->website); ?></a>
                        <?php else: ?>
                        —
                        <?php endif; ?>
                     </p>
                  </div>
                  <div class="col-6 col-md-4 mb-3">
                     <strong>Roles</strong>
                     <p><?php echo e(implode(', ', $user->getRoleNames()->toArray())); ?></p>
                  </div>
               </div>
               <!-- row -->
            </div>
            <!-- card-body -->
         </div>
         <!-- card -->
      </div>
   </div>
</div>
<style>
   /* Instagram-like bio styling */
   .bio {
   font-size: 0.95rem;
   color: #555;
   max-width: 600px;
   margin: 0 auto;
   }
   /* Make avatar overlap banner */
   .profile-header .avatar {
   transform: translateY(-50%);
   }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/profile/show.blade.php ENDPATH**/ ?>