<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Users</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('dashboard')); ?>">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Users</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.create')): ?>
                    <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-sm btn-primary mb-3">Add User</a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.view')): ?>
                    <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-sm btn-secondary mb-3">Roles</a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions.view')): ?>
                    <a href="<?php echo e(route('admin.permissions.index')); ?>" class="btn btn-sm btn-secondary mb-3">Permissions</a>
                <?php endif; ?>
            </div>
        </div>

        <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="multi-filter-select" class="display table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Company</th>
                                <th>Reports To</th>
                                <th>Roles</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Company</th>
                                <th>Reports To</th>
                                <th>Roles</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->profile->company->name ?? '—'); ?></td>
                                <td><?php echo e($user->profile->reportsTo->name ?? '—'); ?></td>
                                <td><?php echo e(implode(', ', $user->getRoleNames()->toArray())); ?></td>
                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.edit')): ?>
                                        <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="btn btn-sm btn-warning">Edit</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.delete')): ?>
                                        <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST" style="display:inline-block">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this user?')">Delete</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center">No users found.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
    $("#multi-filter-select").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([0, 1, 2, 3]).every(function () {
                var column = this;
                var select = $('<select class="form-select"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on("change", function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? "^" + val + "$" : "", true, false).draw();
                    });
                column.data().unique().sort().each(function (d) {
                    if (d) select.append('<option value="' + d + '">' + d + '</option>');
                });
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/users/index.blade.php ENDPATH**/ ?>