<?php $__env->startSection('title', 'Edit User'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="page-inner">
        <div class="card">
            <div class="card-body">

                <form action="<?php echo e(route('admin.users.update', $user)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- Name & Email -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" 
                                   value="<?php echo e(old('name', $user->name)); ?>" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" 
                                   value="<?php echo e(old('email', $user->email)); ?>" required>
                        </div>
                    </div>

                    <!-- Password -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Password <small>(Leave blank to keep current)</small></label>
                            <input type="password" name="password" class="form-control">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Confirm Password</label>
                            <input type="password" name="password_confirmation" class="form-control">
                        </div>
                    </div>

                    <!-- Roles -->
                    <div class="mb-3">
                        <label class="form-label">Roles</label>
                        <select name="roles[]" class="form-select" multiple required>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role); ?>" 
                                    <?php echo e(in_array($role, old('roles', $userRoles ?? [])) ? 'selected' : ''); ?>>
                                    <?php echo e($role); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <hr>

                    <!-- Profile Information -->
                    <h5>Profile Information</h5>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Company</label>
                            <select name="company_id" class="form-select">
                                <option value="">-- Select Company --</option>
                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($company->id); ?>" 
                                        <?php echo e(old('company_id', $profile->company_id ?? '') == $company->id ? 'selected' : ''); ?>>
                                        <?php echo e($company->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Reports To</label>
                            <select name="reports_to_user_id" class="form-select">
                                <option value="">-- Select User --</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($u->id); ?>" 
                                        <?php echo e(old('reports_to_user_id', $profile->reports_to_user_id ?? '') == $u->id ? 'selected' : ''); ?>>
                                        <?php echo e($u->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- Other Profile Fields -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Phone</label>
                            <input type="text" name="phone" class="form-control" 
                                   value="<?php echo e(old('phone', $profile->phone ?? '')); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Reference</label>
                            <input type="text" name="reference" class="form-control" 
                                   value="<?php echo e(old('reference', $profile->reference ?? '')); ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Position</label>
                            <input type="text" name="position" class="form-control" 
                                   value="<?php echo e(old('position', $profile->position ?? '')); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Department</label>
                            <input type="text" name="department" class="form-control" 
                                   value="<?php echo e(old('department', $profile->department ?? '')); ?>">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">About</label>
                        <textarea name="about" class="form-control" rows="3"><?php echo e(old('about', $profile->about ?? '')); ?></textarea>
                    </div>

                    <div class="mt-3">
                        <button class="btn btn-primary">Update User</button>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">Cancel</a>
                    </div>

                </form>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/users/edit.blade.php ENDPATH**/ ?>