<section>
    <header class="mb-4">
        <h5 class="fw-semibold text-danger">
            Delete Account
        </h5>

        <p class="text-muted">
            Once your account is deleted, all of its resources and data will be permanently deleted.
            Before deleting your account, please download any data you wish to retain.
        </p>
    </header>

    <!-- Delete Button -->
    <button
        type="button"
        class="btn btn-danger"
        data-bs-toggle="modal"
        data-bs-target="#confirmUserDeletion"
    >
        Delete Account
    </button>

    <!-- Modal -->
    <div
        class="modal fade"
        id="confirmUserDeletion"
        tabindex="-1"
        aria-labelledby="confirmUserDeletionLabel"
        aria-hidden="true"
    >
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <form method="POST" action="<?php echo e(route('profile.destroy')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>

                    <div class="modal-header">
                        <h5 class="modal-title text-danger" id="confirmUserDeletionLabel">
                            Are you sure?
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">
                        <p class="text-muted">
                            Once your account is deleted, all data will be permanently removed.
                            Please enter your password to confirm.
                        </p>

                        <div class="mb-3">
                            <label for="password" class="form-label">
                                Password
                            </label>
                            <input
                                type="password"
                                name="password"
                                id="password"
                                class="form-control <?php if($errors->userDeletion->has('password')): ?> is-invalid <?php endif; ?>"
                                required
                            >

                            <?php if($errors->userDeletion->has('password')): ?>
                                <div class="invalid-feedback">
                                    <?php echo e($errors->userDeletion->first('password')); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button
                            type="button"
                            class="btn btn-secondary"
                            data-bs-dismiss="modal"
                        >
                            Cancel
                        </button>

                        <button type="submit" class="btn btn-danger">
                            Delete Account
                        </button>
                    </div>

                </form>

            </div>
        </div>
    </div>
</section>
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/profile/partials/delete-user-form.blade.php ENDPATH**/ ?>