<?php $__env->startSection('title', 'Lead Stages'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Lead Stages</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('dashboard')); ?>"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Lead Stages</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leadstages.create')): ?>
                    <a href="<?php echo e(route('admin.lead-stages.create')); ?>" class="btn btn-sm btn-primary mb-3">
                        Add Stage
                    </a>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="leadStagesTable" class="display table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Parent</th>
                                <th>Order</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>Name</th>
                                <th>Parent</th>
                                <th>Order</th>
                                <th>Status</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($stage->name); ?></td>
                                    <td><?php echo e(optional($stage->parent)->name ?? '-'); ?></td>
                                    <td><?php echo e($stage->order); ?></td>
                                    <td>
                                        <span class="badge <?php echo e($stage->status ? 'badge-success' : 'badge-secondary'); ?>">
                                            <?php echo e($stage->status ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leadstages.edit')): ?>
                                            <a href="<?php echo e(route('admin.lead-stages.edit', $stage)); ?>"
                                               class="btn btn-sm btn-warning mb-1">
                                                Edit
                                            </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leadstages.delete')): ?>
                                            <form action="<?php echo e(route('admin.lead-stages.destroy', $stage)); ?>"
                                                  method="POST" style="display:inline-block">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-danger mb-1"
                                                    onclick="return confirm('Delete this stage?')">
                                                    Delete
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">No stages found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
    $("#leadStagesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([0,1,3]).every(function () {
                var column = this;
                var select = $('<select class="form-select"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function (d) {
                    if (d) {
                        var text = d.replace(/<[^>]*>/g, '');
                        select.append('<option value="'+text+'">'+text+'</option>');
                    }
                });
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/lead_stages/index.blade.php ENDPATH**/ ?>