<?php
    $authUser  = auth()->user();
    $companyId = optional($authUser->profile)->company_id;
?>

<div class="row">
    
    <div class="col-md-4 mb-3">
        <label class="form-label">Name</label>
        <input type="text"
               name="name"
               value="<?php echo e(old('name', $stage->name ?? '')); ?>"
               class="form-control"
               required>
    </div>

    
    <div class="col-md-4 mb-3">
        <label class="form-label">Parent Stage</label>
        <select name="parent_id" class="form-select form-control">
            <option value="">None</option>
            <?php $__currentLoopData = $parents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($parent->id); ?>"
                    <?php if(old('parent_id', $stage->parent_id ?? '') == $parent->id): echo 'selected'; endif; ?>>
                    <?php echo e($parent->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    
    <div class="col-md-4 mb-3">
        <label class="form-label">Company</label>

        
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leadstages.view.all')): ?>
            <select name="company_id" class="form-select form-control">
                <option value="">-- Select Company --</option>
                <?php $__currentLoopData = \App\Models\Company::orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($company->id); ?>"
                        <?php if(old('company_id', $stage->company_id ?? '') == $company->id): echo 'selected'; endif; ?>>
                        <?php echo e($company->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        <?php else: ?>
            
            <input type="text"
                   class="form-control"
                   value="<?php echo e($stage->company->name ?? $authUser->profile->company->name ?? '-'); ?>"
                   readonly>

            <input type="hidden"
                   name="company_id"
                   value="<?php echo e(old('company_id', $stage->company_id ?? $companyId)); ?>">
        <?php endif; ?>
    </div>

    
    <div class="col-md-6 mb-3">
        <label class="form-label">Order</label>
        <input type="number"
               name="order"
               value="<?php echo e(old('order', $stage->order ?? 0)); ?>"
               class="form-control">
    </div>

    
    <div class="col-md-6 mb-3">
        <label class="form-label">Status</label>
        <select name="status" class="form-select form-control">
            <option value="1" <?php if(old('status', $stage->status ?? 1) == 1): echo 'selected'; endif; ?>>Active</option>
            <option value="0" <?php if(old('status', $stage->status ?? 1) == 0): echo 'selected'; endif; ?>>Inactive</option>
        </select>
    </div>
</div>

<div class="text-end">
    <button type="submit" class="btn btn-primary">Save</button>
    <a href="<?php echo e(route('admin.lead-stages.index')); ?>" class="btn btn-secondary">Cancel</a>
</div>
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/lead_stages/_form.blade.php ENDPATH**/ ?>