<?php $__env->startSection('title', 'Booking Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="page-inner">

        <div class="row mb-3">
            <div class="col-md-8">
                <h3 class="fw-bold">Booking Details</h3>
            </div>
            <div class="col-md-4 text-end">
                <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-secondary btn-sm">Back to List</a>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <p><strong>Customer Name:</strong> <?php echo e($booking->customer_name); ?></p>
                <p><strong>Phone:</strong> <?php echo e($booking->customer_phone); ?></p>
                <p><strong>Reference:</strong> <?php echo e($booking->customer_reference ?? '-'); ?></p>
                <p><strong>Slot:</strong> <?php echo e($booking->slot->shift ?? '-'); ?> (<?php echo e($booking->slot->start_time ?? '-'); ?> - <?php echo e($booking->slot->end_time ?? '-'); ?>)</p>
                <p><strong>Location:</strong> <?php echo e($booking->slot->location ?? '-'); ?></p>
                <p><strong>User:</strong> <?php echo e($booking->user->name ?? '-'); ?></p>
                <p><strong>Stage:</strong> <?php echo e(ucfirst($booking->stage)); ?></p>
                <p><strong>Status:</strong> <?php echo e(ucfirst($booking->status)); ?></p>
                <p><strong>Extra Data:</strong> <pre><?php echo e(json_encode($booking->data, JSON_PRETTY_PRINT)); ?></pre></p>
                <p><strong>Created At:</strong> <?php echo e($booking->created_at->format('Y-m-d H:i')); ?></p>
                <p><strong>Updated At:</strong> <?php echo e($booking->updated_at->format('Y-m-d H:i')); ?></p>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/bookings/show.blade.php ENDPATH**/ ?>