<?php echo csrf_field(); ?>

<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label">Name</label>
        <input name="name"
               value="<?php echo e(old('name', $category->name ?? '')); ?>"
               class="form-control"
               required>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label">Slug</label>
        <input name="slug"
               value="<?php echo e(old('slug', $category->slug ?? '')); ?>"
               class="form-control"
               required>
    </div>
</div>

<div class="row">
    <div class=" col-md-4 mb-3">
        <label class="form-label">Parent Category</label>
        <select name="parent_id" class="form-select form-control">
            <option value="">— None —</option>
            <?php $__currentLoopData = $parents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($parent->id); ?>"
                    <?php if(old('parent_id', $category->parent_id ?? '') == $parent->id): echo 'selected'; endif; ?>>
                    <?php echo e($parent->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-md-4 mb-3">
        <label class="form-label">Order</label>
        <input type="number"
               name="order"
               value="<?php echo e(old('order', $category->order ?? 0)); ?>"
               class="form-control">
    </div>

    <div class="col-md-4 mb-3">
        <label class="form-label">Status</label>
        <select name="status" class="form-select form-control">
            <option value="1" <?php if(old('status', $category->status ?? 1) == 1): echo 'selected'; endif; ?>>Active</option>
            <option value="0" <?php if(old('status', $category->status ?? 1) == 0): echo 'selected'; endif; ?>>Inactive</option>
        </select>
    </div>
</div>

<div class="mb-3">
    <label class="form-label">Icon</label>
    <input name="icon"
           value="<?php echo e(old('icon', $category->icon ?? '')); ?>"
           class="form-control">
</div>

<div class="mb-3">
    <label class="form-label">Short Description</label>
    <input name="short_description"
           value="<?php echo e(old('short_description', $category->short_description ?? '')); ?>"
           class="form-control">
</div>

<div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description"
              rows="4"
              class="form-control"><?php echo e(old('description', $category->description ?? '')); ?></textarea>
</div>

<div class="mb-3">
    <label class="form-label">Meta (JSON)</label>
    <textarea name="meta"
              rows="3"
              class="form-control"
              placeholder='{"title":"SEO title","keywords":["a","b"]}'><?php echo e(old('meta', isset($category->meta) ? json_encode($category->meta) : '')); ?></textarea>
</div>

<!-- <button class="btn btn-success">
    Save Category
</button>
<a href="<?php echo e(route('admin.categories.index')); ?>" class="btn btn-secondary">
    Cancel
</a> -->
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/categories/_form.blade.php ENDPATH**/ ?>