<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="page-inner">
        <div class="container">
            <div class="row row-demo-grid">
                <div class="col-md-8">
                    <div class="page-header">
                        <h3 class="fw-bold mb-3">Add User</h3>
                        <ul class="breadcrumbs mb-3">
                            <li class="nav-home">
                                <a href="<?php echo e(route('dashboard')); ?>">
                                    <i class="icon-home"></i>
                                </a>
                            </li>
                            <li class="separator"><i class="icon-arrow-right"></i></li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.users.index')); ?>">Users</a>
                            </li>
                            <li class="separator"><i class="icon-arrow-right"></i></li>
                            <li class="nav-item">Add User</li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-4 ms-auto">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.view')): ?>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-sm btn-primary mb-3">Users</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.view')): ?>
                        <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-sm btn-secondary mb-3">Roles</a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions.view')): ?>
                        <a href="<?php echo e(route('admin.permissions.index')); ?>" class="btn btn-sm btn-secondary mb-3">Permissions</a>
                    <?php endif; ?>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.users.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" value="<?php echo e(old('name')); ?>" required>
                </div>

                
                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo e(old('email')); ?>" required>
                </div>

                
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" required>
                </div>

                
                <div class="mb-3">
                    <label class="form-label">Confirm Password</label>
                    <input type="password" name="password_confirmation" class="form-control" required>
                </div>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.change-company')): ?>
                <div class="mb-3">
                    <label class="form-label">Company</label>
                    <select name="company_id" class="form-control">
                        <option value="">— No Company —</option>
                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($company->id); ?>"
                                <?php echo e(old('company_id') == $company->id ? 'selected' : ''); ?>>
                                <?php echo e($company->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php endif; ?>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.change-reports-to')): ?>
                <div class="mb-3">
                    <label class="form-label">Reports To</label>
                    <select name="reports_to_user_id" class="form-control">
                        <option value="">— None —</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reportUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($reportUser->id); ?>"
                                <?php echo e(old('reports_to_user_id') == $reportUser->id ? 'selected' : ''); ?>>
                                <?php echo e($reportUser->name); ?> (<?php echo e($reportUser->email); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small class="text-muted">Select the manager this user reports to.</small>
                </div>
                <?php endif; ?>

                
                <div class="mb-3">
                    <label class="form-label">Roles</label>
                    <select name="roles[]" class="form-control" multiple required>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role); ?>"
                                <?php echo e(in_array($role, old('roles', [])) ? 'selected' : ''); ?>>
                                <?php echo e($role); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small class="text-muted">Hold Ctrl (Windows) / Cmd (Mac) to select multiple roles.</small>
                </div>

                
                <button type="submit" class="btn btn-success">Create User</button>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/users/create.blade.php ENDPATH**/ ?>