<?php $__env->startSection('title', 'Companies'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid mb-3">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Companies</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('dashboard')); ?>">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator">
                            <i class="icon-arrow-right"></i>
                        </li>
                        <li class="nav-item">
                            <a href="#">Companies</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('companies.create')): ?>
                    <a href="<?php echo e(route('admin.companies.create')); ?>" class="btn btn-sm btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Add Company
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="companiesTable" class="table table-striped table-hover display">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Status</th>
                                <th>Order</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($company->name); ?></td>
                                    <td><?php echo e($company->slug); ?></td>
                                    <td><?php echo e($company->status ? 'Active' : 'Inactive'); ?></td>
                                    <td><?php echo e($company->order ?? '-'); ?></td>
                                    <td class="d-flex gap-1">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('companies.edit')): ?>
                                            <a href="<?php echo e(route('admin.companies.edit', $company)); ?>" class="btn btn-sm btn-warning">
                                                Edit
                                            </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('companies.delete')): ?>
                                            <form action="<?php echo e(route('admin.companies.destroy', $company)); ?>" method="POST" onsubmit="return confirm('Are you sure?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-danger">
                                                    Delete
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">No companies found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $("#companiesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([1, 2, 3]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/companies/index.blade.php ENDPATH**/ ?>