<?php $__env->startSection('title', 'Lead Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="page-inner">
        <div class="page-header mb-3">
            <h3 class="fw-bold">Lead Details</h3>
            <ul class="breadcrumbs mb-0">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>"><i class="icon-home"></i></a>
                </li>
                <li class="separator"><i class="icon-arrow-right"></i></li>
                <li class="nav-item"><a href="<?php echo e(route('admin.leads.index')); ?>">Leads</a></li>
                <li class="separator"><i class="icon-arrow-right"></i></li>
                <li class="nav-item"><a href="#">Lead Details</a></li>
            </ul>
        </div>
        <div class="row">
            <div class="col-md-3">
                
                <div class="card mb-3 overflow-hidden">
                    <div class="card-header bg-secondary text-white">Owner / Lead Information</div>
                    <div class="card-body ">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Name:</p>
                            <p class="text-end"><?php echo e($lead->name); ?></p>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Phone:</p>
                            <p class="text-end"><?php echo e($lead->phone); ?></p>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Email:</p>
                            <p class="text-end"><?php echo e($lead->email ?? '-'); ?></p>
                        </div>
                        <div>
                            <select name="lead_stage" id="lead_stage" class="form-select" >
                                <option value="">-- Select Stage --</option>
                                <?php $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($stage->id); ?>"
                                        <?php if($lead->stage_id == $stage->id): echo 'selected'; endif; ?>>
                                        <?php echo e($stage->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">Quick Actions</div>
                    <div class="d-flex justify-content-between align-items-center mb-2 p-3">
                        <div>
                            <a href="tel:<?php echo e($lead->phone); ?>" class="btn btn-sm btn-outline-secondary">Call</a>
                        </div> 
                        <div>
                            <a href="mailto:<?php echo e($lead->email); ?>" class="btn btn-sm btn-primary">Email</a>
                        </div>
                        <div>
                            <a href="https://wa.me/<?php echo e($lead->phone); ?>" class="btn btn-sm btn-success">WhatsApp</a>
                        </div>

                    </div>
                </div>
                <div class="card mb-3">
                    <div class="card-header">Notes</div>
                    <div class="card-body">
                        <p><?php echo e($lead->note ?? '-'); ?></p>
                    </div>
                </div>

                
                <div class="card mb-3 overflow-hidden">
                    <div class="card-header bg-secondary text-white">Assigned User</div>
                    <div class="p-3">
                        <select name="assigned_user" id="assigned_user" class="form-select" >
                        <option value="">-- Select User --</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>"
                                <?php if($lead->user_id == $user->id): echo 'selected'; endif; ?>>
                                <?php echo e($user->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Name:</p>
                            <p class="text-end"><?php echo e($lead->user->name ?? '-'); ?></p>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Role:</p>
                            <p class="text-end"><?php echo e($lead->user->role->name ?? '-'); ?></p>    
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Company:</p>
                            <p class="text-end"><?php echo e($lead->user->company->name ?? '-'); ?></p>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Email:</p>
                            <p class="text-end"><?php echo e($lead->user->email ?? '-'); ?></p>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p>Phone:</p>
                            <p class="text-end"><?php echo e($lead->user->phone ?? '-'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="">
					<div class="card-body">
						<ul class="nav nav-pills nav-secondary nav-pills-no-bd" id="pills-tab-without-border" role="tablist">
							<li class="nav-item">
								<a class="nav-link active" id="pills-activity-tab-nobd" data-bs-toggle="pill" href="#pills-activity-nobd" role="tab" aria-controls="pills-activity-nobd" aria-selected="true">Activity</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" id="pills-info-tab-nobd" data-bs-toggle="pill" href="#pills-info-nobd" role="tab" aria-controls="pills-info-nobd" aria-selected="false">Info</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" id="pills-doc-tab-nobd" data-bs-toggle="pill" href="#pills-doc-nobd" role="tab" aria-controls="pills-doc-nobd" aria-selected="false">Documents</a>
							</li>
                            <li class="nav-item">
                                <a class="nav-link" id="pills-notes-tab-nobd" data-bs-toggle="pill" href="#pills-notes-nobd" role="tab" aria-controls="pills-notes-nobd" aria-selected="false">Notes</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="pills-data-tab-nobd" data-bs-toggle="pill" href="#pills-data-nobd" role="tab" aria-controls="pills-data-nobd" aria-selected="false">Data</a>
                            </li>
						</ul>
						<div class="tab-content mt-2 mb-3 card p-3" id="pills-without-border-tabContent">
							<div class="tab-pane fade show active" id="pills-activity-nobd" role="tabpanel" aria-labelledby="pills-activity-tab-nobd">
								<!-- TimeLine -->
                                <h3 class="fw-bold mb-3">Activities</h3>
                                <ul class="timeline">
                                    
                                </ul>
                            </div>
                            <div class="tab-pane fade" id="pills-info-nobd" role="tabpanel" aria-labelledby="pills-info-tab-nobd">
                                <h3 class="fw-bold mb-3">Lead Information</h3>
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <p><strong>Name:</strong></p>
                                    <p class="text-end"><?php echo e($lead->name); ?></p>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <p><strong>Email:</strong></p>
                                    <p class="text-end"><?php echo e($lead->email); ?></p>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <p><strong>Phone:</strong></p>
                                    <p class="text-end"><?php echo e($lead->phone); ?></p>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-doc-nobd" role="tabpanel" aria-labelledby="pills-doc-tab-nobd">
                                <form action="#">
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label for="documentTitle" class="form-label">Document Title</label>
                                            <input type="text" class="form-control" id="documentTitle" placeholder="Enter document title">
                                            <input type="hidden" name="lead_id" value="<?php echo e($lead->id); ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="formFile" class="form-label">Upload Document</label>
                                            <input class="form-control" type="file" id="formFile">
                                        </div>
                                        <div class="col-md-2 mb-3 d-flex align-items-end">
                                            <button type="submit" class="btn btn-primary"><i class="fas fa-upload"></i></button>
                                        </div>
                                        <small class="form-text text-muted">Please provide a title for the document.</small>
                                    </div>
                                </form>
								<div class="row">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Title</th>
                                                <th>Uploaded At</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                           
                                        </tbody>
                                    </table>
                                </div>
							</div>
                            <div class="tab-pane fade" id="pills-notes-nobd" role="tabpanel" aria-labelledby="pills-notes-tab-nobd">
                                <h3 class="fw-bold mb-3">Notes</h3>
                                <p><?php echo e($lead->note ?? '-'); ?></p>
                            </div>
                            <div class="tab-pane fade" id="pills-data-nobd" role="tabpanel" aria-labelledby="pills-data-tab-nobd">
                                <h3 class="fw-bold mb-3">Data</h3>
                                <pre><?php echo e(json_encode($lead->data, JSON_PRETTY_PRINT)); ?></pre>
                            </div>
						</div>
					</div>
				</div>
            </div>
            <div class="col-md-3 ">  
                
                <div class="card mb-3 overflow-hidden">
                    <div class="card-header bg-secondary text-white">Source Information</div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p><strong>Portal:</strong></p>
                            <p class="text-end"><?php echo e($lead->portal ?? '-'); ?></p>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p><strong>Reference:</strong></p>
                            <p class="text-end"><?php echo e($lead->reference ?? '-'); ?></p>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <p><strong>Portal Lead ID:</strong></p>
                            <p class="text-end"><?php echo e($lead->portal_lead_id ?? '-'); ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="card mb-3 overflow-hidden">
                    <div class="card-header bg-secondary text-white">Service / Product Information</div>
                    <div class="card-body">
                        <p><strong>Stage:</strong> <?php echo e($lead->stage->name ?? '-'); ?></p>
                        <p><strong>Status:</strong> <?php echo e(ucfirst($lead->status)); ?></p>
                        <p><strong>Company:</strong> <?php echo e($lead->company->name ?? '-'); ?></p>
                        <p><strong>Data:</strong></p>
                        <pre><?php echo e(json_encode($lead->data, JSON_PRETTY_PRINT)); ?></pre>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/leads/show.blade.php ENDPATH**/ ?>