<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between mb-3">
        <h4 class="fw-bold">Lead Stages – Kanban</h4>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leadstages.create')): ?>
            <a href="<?php echo e(route('admin.lead-stages.create')); ?>" class="btn btn-primary">
                + Add Stage
            </a>
        <?php endif; ?>
    </div>

    <div class="row flex-nowrap overflow-auto">

        <?php $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-3">
                <div class="card shadow-sm mb-3">
                    <div class="card-header bg-dark text-white">
                        <strong><?php echo e($stage->name); ?></strong>
                    </div>

                    <div class="card-body p-2 kanban-column">

                        <?php $__empty_1 = true; $__currentLoopData = $stage->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="card mb-2">
                                <div class="card-body p-2">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span><?php echo e($child->name); ?></span>

                                        <div class="btn-group btn-group-sm">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leadstages.edit')): ?>
                                                <a href="<?php echo e(route('admin.lead-stages.edit', $child)); ?>"
                                                   class="btn btn-outline-secondary">
                                                    ✏️
                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leadstages.delete')): ?>
                                                <form method="POST"
                                                      action="<?php echo e(route('admin.lead-stages.destroy', $child)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button class="btn btn-outline-danger"
                                                        onclick="return confirm('Delete this stage?')">
                                                        🗑️
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-muted text-center small p-2">
                                No stages
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/lead_stages/kanban.blade.php ENDPATH**/ ?>