<?php
    $authUser = auth()->user();
?>

<div class="row">
    
    <div class="col-md-4 mb-3">
        <label>Name</label>
        <input type="text" name="name" class="form-control"
               value="<?php echo e(old('name', $lead->name ?? '')); ?>" required>
    </div>

    
    <div class="col-md-4 mb-3">
        <label>Phone</label>
        <input type="text" name="phone" class="form-control"
               value="<?php echo e(old('phone', $lead->phone ?? '')); ?>" required>
    </div>

    
    <div class="col-md-4 mb-3">
        <label>Email</label>
        <input type="email" name="email" class="form-control"
               value="<?php echo e(old('email', $lead->email ?? '')); ?>">
    </div>

    
    <div class="col-md-3 mb-3">
        <label>Reference</label>
        <input type="text" name="reference" class="form-control"
               value="<?php echo e(old('reference', $lead->reference ?? '')); ?>">
    </div>

    
    <div class="col-md-3 mb-3">
        <label>Stage</label>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.change_stage')): ?>
            <select name="stage_id" class="form-select">
                <option value="">-- Select Stage --</option>
                <?php $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($stage->id); ?>"
                        <?php if(old('stage_id', $lead->stage_id ?? '') == $stage->id): echo 'selected'; endif; ?>>
                        <?php echo e($stage->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        <?php else: ?>
            <input type="text" class="form-control" value="<?php echo e($lead->stage->name ?? '-'); ?>" readonly>
            <input type="hidden" name="stage_id" value="<?php echo e($lead->stage_id ?? ''); ?>">
        <?php endif; ?>
    </div>

    
    <div class="col-md-3 mb-3">
        <label>User</label>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.change_user')): ?>
            <select name="user_id" class="form-select">
                <option value="">-- Select User --</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>"
                        <?php if(old('user_id', $lead->user_id ?? '') == $user->id): echo 'selected'; endif; ?>>
                        <?php echo e($user->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        <?php else: ?>
            <input type="text" class="form-control"
                   value="<?php echo e($lead->user->name ?? $authUser->name); ?>" readonly>
            <input type="hidden" name="user_id" value="<?php echo e($lead->user_id ?? $authUser->id); ?>">
        <?php endif; ?>
    </div>

    
    <div class="col-md-3 mb-3">
        <label>Portal</label>
        <input type="text" name="portal" class="form-control"
               value="<?php echo e(old('portal', $lead->portal ?? '')); ?>">
    </div>

    
    <div class="col-md-12 mb-3">
        <label>Note</label>
        <textarea name="note" class="form-control" rows="3"><?php echo e(old('note', $lead->note ?? '')); ?></textarea>
    </div>

    
    <div class="col-md-12 text-end">
        <button class="btn btn-primary">Save Lead</button>
    </div>
</div>
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/leads/_form.blade.php ENDPATH**/ ?>