<?php echo csrf_field(); ?>


<?php if(isset($slot)): ?>
<div class="row mb-3">
    <div class="col-md-3">
        <label class="form-label">Schedule User</label>
        <input type="text" class="form-control" value="<?php echo e($booking->slot->schedule->user->name ?? '-'); ?>" disabled>
    </div>
    <div class="col-md-3">
        <label class="form-label">Booked User</label>
        <input type="text" class="form-control" value="<?php echo e($booking->slot->user->name ?? '-'); ?>" disabled>
    </div>
    <div class="col-md-3">
        <label class="form-label">Schedule Date</label>
        <input type="text" class="form-control" value="<?php echo e($booking->slot->schedule->schedule_date ?? '-'); ?>" disabled>
    </div>
    <div class="col-md-3">
        <label class="form-label">Shift</label>
        <input type="text" class="form-control" value="<?php echo e(ucfirst($slot->shift)); ?>" disabled>
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-4">
        <label class="form-label">Location</label>
        <input type="text" class="form-control" value="<?php echo e($slot->location); ?>" disabled>
    </div>
    <div class="col-md-2">
        <label class="form-label">Start Time</label>
        <input type="text" class="form-control" value="<?php echo e(\Carbon\Carbon::parse($slot->start_time)->format('H:i')); ?>" disabled>
    </div>
    <div class="col-md-2">
        <label class="form-label">End Time</label>
        <input type="text" class="form-control" value="<?php echo e(\Carbon\Carbon::parse($slot->end_time)->format('H:i')); ?>" disabled>
    </div>
    <div class="col-md-4">
        <label class="form-label">Slot Fees</label>
        <input type="text" class="form-control" value="<?php echo e(number_format($slot->fees, 2)); ?>" disabled>
    </div>
</div>


<input type="hidden" name="slot_id" value="<?php echo e($slot->id); ?>">
<input type="hidden" name="user_id" value="<?php echo e($scheduledUser->id ?? ''); ?>">
<?php endif; ?>


<div class="row mb-3">
    <div class="col-md-6">
        <label class="form-label">Customer Name</label>
        <input type="text" name="customer_name" value="<?php echo e(old('customer_name')); ?>" class="form-control" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">Customer Phone</label>
        <input type="text" name="customer_phone" value="<?php echo e(old('customer_phone')); ?>" class="form-control" required>
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-6">
        <label class="form-label">Stage</label>
        <select name="stage" class="form-select">
            <option value="new" <?php if(old('stage') == 'new'): echo 'selected'; endif; ?>>New</option>
            <option value="follow_up" <?php if(old('stage') == 'follow_up'): echo 'selected'; endif; ?>>Follow Up</option>
            <option value="completed" <?php if(old('stage') == 'completed'): echo 'selected'; endif; ?>>Completed</option>
        </select>
    </div>
    <div class="col-md-6">
        <label class="form-label">Status</label>
        <select name="status" class="form-select">
            <option value="pending" <?php if(old('status') == 'pending'): echo 'selected'; endif; ?>>Pending</option>
            <option value="confirmed" <?php if(old('status') == 'confirmed'): echo 'selected'; endif; ?>>Confirmed</option>
            <option value="cancelled" <?php if(old('status') == 'cancelled'): echo 'selected'; endif; ?>>Cancelled</option>
            <option value="completed" <?php if(old('status') == 'completed'): echo 'selected'; endif; ?>>Completed</option>
        </select>
    </div>
</div>


<!-- <div class="row mb-3">
    <div class="col-md-12">
        <label class="form-label">Additional Data (JSON)</label>
        <textarea name="data" class="form-control" rows="3" placeholder='{"age":30,"notes":"Sample"}'><?php echo e(old('data')); ?></textarea>
    </div>
</div> -->

<div class="mb-3">
    <button class="btn btn-success">Save Booking</button>
    <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-secondary">Cancel</a>
</div>
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/bookings/_form.blade.php ENDPATH**/ ?>