
<div class="mb-3">
    <label class="form-label">Search Location</label>
    <input type="text" id="location_search" class="form-control" placeholder="Type a city or area">
    <ul id="suggestions" class="list-group mt-1"></ul>
</div>

<div class="mb-3">
    <label class="form-label">Name</label>
    <input type="text"
           name="name"
           id="location_name"
           class="form-control"
           value="<?php echo e(old('name', $location->name ?? '')); ?>"
           required>
</div>

<div class="mb-3">
    <label class="form-label">Slug</label>
    <input type="text"
           name="slug"
           id="location_slug"
           class="form-control"
           value="<?php echo e(old('slug', $location->slug ?? '')); ?>">
</div>

<div class="mb-3">
    <label class="form-label">Title</label>
    <input type="text"
           name="title"
           class="form-control"
           value="<?php echo e(old('title', $location->title ?? '')); ?>">
</div>

<div class="mb-3">
    <label class="form-label">Parent Location</label>
    <select name="parent_id" class="form-select">
        <option value="">-- None --</option>
        <?php $__currentLoopData = $parents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($parent->id); ?>"
                <?php echo e(old('parent_id', $location->parent_id ?? '') == $parent->id ? 'selected' : ''); ?>>
                <?php echo e($parent->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label">Latitude</label>
        <input type="text"
               name="latitude"
               id="latitude"
               class="form-control"
               value="<?php echo e(old('latitude', $location->latitude ?? '')); ?>">
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label">Longitude</label>
        <input type="text"
               name="longitude"
               id="longitude"
               class="form-control"
               value="<?php echo e(old('longitude', $location->longitude ?? '')); ?>">
    </div>
</div>

<div class="mb-3">
    <label class="form-label">Short Description</label>
    <input type="text" name="short_description" class="form-control" value="<?php echo e(old('short_description', $location->short_description ?? '')); ?>">
</div>

<div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description" class="form-control" rows="5"><?php echo e(old('description', $location->description ?? '')); ?></textarea>
</div>

<div class="mb-3">
    <label class="form-label">Meta (JSON)</label>
    <textarea name="meta" class="form-control" rows="3"><?php echo e(old('meta', isset($location->meta) ? json_encode($location->meta) : '')); ?></textarea>
</div>

<div class="mb-3">
    <label class="form-label">Extra Data (JSON)</label>
    <textarea name="data" class="form-control" rows="3"><?php echo e(old('data', isset($location->data) ? json_encode($location->data) : '')); ?></textarea>
</div>

<div class="mb-3">
    <label class="form-label">Image</label>
    <input type="file" name="image" class="form-control">
    <?php if(!empty($location->image)): ?>
        <img src="<?php echo e(asset('storage/' . $location->image)); ?>" class="mt-2" width="100">
    <?php endif; ?>
</div>

<div class="mb-3">
    <label class="form-label">Banner</label>
    <input type="file" name="banner" class="form-control">
    <?php if(!empty($location->banner)): ?>
        <img src="<?php echo e(asset('storage/' . $location->banner)); ?>" class="mt-2" width="150">
    <?php endif; ?>
</div>

<div class="mb-3">
    <label class="form-label">Icon</label>
    <input type="file" name="icon" class="form-control">
    <?php if(!empty($location->icon)): ?>
        <img src="<?php echo e(asset('storage/' . $location->icon)); ?>" class="mt-2" width="50">
    <?php endif; ?>
</div>

<div class="mb-3">
    <label class="form-label">Order</label>
    <input type="number" name="order" class="form-control" value="<?php echo e(old('order', $location->order ?? 0)); ?>">
</div>

<div class="mb-3">
    <label class="form-label">Status</label>
    <select name="status" class="form-select">
        <option value="1" <?php echo e(old('status', $location->status ?? 1) ? 'selected' : ''); ?>>Active</option>
        <option value="0" <?php echo e(!old('status', $location->status ?? 1) ? 'selected' : ''); ?>>Inactive</option>
    </select>
</div>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const nameInput = document.getElementById('location_name');
    const slugInput = document.getElementById('location_slug');

    // Auto-generate slug while typing name
    nameInput.addEventListener('input', function () {
        let val = this.value.toLowerCase()
                             .replace(/[^a-z0-9]+/g, '-')
                             .replace(/^-+|-+$/g, '');
        slugInput.value = val;
    });

    // Location search using OpenStreetMap Nominatim API (free)
    const searchInput = document.getElementById('location_search');
    const suggestions = document.getElementById('suggestions');

    let timeout = null;
    searchInput.addEventListener('input', function () {
        const query = this.value;
        if (timeout) clearTimeout(timeout);
        if (query.length < 3) {
            suggestions.innerHTML = '';
            return;
        }

        timeout = setTimeout(async () => {
            const url = `https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(query)}`;
            const res = await fetch(url);
            const data = await res.json();

            suggestions.innerHTML = '';
            data.slice(0, 5).forEach(place => {
                const li = document.createElement('li');
                li.classList.add('list-group-item', 'list-group-item-action');
                li.textContent = place.display_name;
                li.addEventListener('click', () => {
                    document.getElementById('location_name').value = place.display_name;
                    document.getElementById('latitude').value = place.lat;
                    document.getElementById('longitude').value = place.lon;
                    slugInput.value = place.display_name.toLowerCase()
                                                        .replace(/[^a-z0-9]+/g, '-')
                                                        .replace(/^-+|-+$/g, '');
                    suggestions.innerHTML = '';
                });
                suggestions.appendChild(li);
            });
        }, 300);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/locations/_form.blade.php ENDPATH**/ ?>