<?php
use App\Models\Schedule;
$authUser = auth()->user();
$schedule = $schedule ?? new Schedule();
?>

<div class="card mb-4">
   <div class="card-header fw-bold">Basic Information</div>
   <div class="card-body">
      <div class="row">
         
         <div class="col-md-6 mb-3">
            <label class="form-label">User</label>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.change.user')): ?>
            <select name="user_id" class="form-select form-control" required>
               <option value="">-- Select User --</option>
               <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <option value="<?php echo e($user->id); ?>"
               <?php echo e(old('user_id', $schedule->user_id) == $user->id ? 'selected' : ''); ?>>
               <?php echo e($user->name); ?>

               </option>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php else: ?>
            <input type="text" class="form-control"
               value="<?php echo e($schedule->user->name ?? $authUser->name); ?>" readonly>
            <input type="hidden" name="user_id"
               value="<?php echo e($schedule->user_id ?? $authUser->id); ?>">
            <?php endif; ?>
         </div>
         
         <div class="col-md-6 mb-3">
            <label class="form-label">Company</label>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.change.company')): ?>
            <select name="company_id" class="form-select form-control" required>
               <option value="">-- Select Company --</option>
               <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <option value="<?php echo e($company->id); ?>"
               <?php echo e(old('company_id', $schedule->company_id) == $company->id ? 'selected' : ''); ?>>
               <?php echo e($company->name); ?>

               </option>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php else: ?>
            <input type="text" class="form-control"
               value="<?php echo e($schedule->company->name ?? $authUser->profile->company->name ?? ''); ?>" readonly>
            <input type="hidden" name="company_id"
               value="<?php echo e($schedule->company_id ?? $authUser->profile->company_id); ?>">
            <?php endif; ?>
         </div>
      </div>
      <div class="row">
         
         <div class="col-md-3 mb-3">
            <label class="form-label">Schedule Date</label>
            <input type="date" name="schedule_date" class="form-control"
               value="<?php echo e(old('schedule_date', optional($schedule->schedule_date)->format('Y-m-d'))); ?>"
               required>
         </div>
         
         <div class="col-md-3 mb-3">
            <label class="form-label">Per Customer Time (mins)</label>
            <input type="number" name="per_customer_time" class="form-control"
               value="<?php echo e(old('per_customer_time', $schedule->per_customer_time ?? 30)); ?>">
         </div>
         
         <div class="col-md-3 mb-3">
            <label class="form-label">Fees</label>
            <input type="number" step="0.01" name="fees" class="form-control"
               value="<?php echo e(old('fees', $schedule->fees ?? 0)); ?>">
         </div>
         
         <div class="col-md-3 mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select form-control">
            <option value="1" <?php echo e(old('status', $schedule->status ?? 1) == 1 ? 'selected' : ''); ?>>
            Active
            </option>
            <option value="0" <?php echo e(old('status', $schedule->status ?? 1) == 0 ? 'selected' : ''); ?>>
            Inactive
            </option>
            </select>
         </div>
      </div>
   </div>
</div>
<div class="row">
   <div class="col-md-6">
      
      <div class="card mb-4">
         <div class="card-header fw-bold">Morning Shift</div>
         <div class="card-body">
            <div class="mb-3">
               <label class="form-label">Location</label>
               <input type="text" name="morning_location" class="form-control"
                  value="<?php echo e(old('morning_location', $schedule->morning_location)); ?>" required>
            </div>
            <div class="row">
               <div class="col-md-6 mb-3">
                  <label class="form-label">Start Time</label>
                  <input type="time" name="morning_start_time" class="form-control"
                     value="<?php echo e(old('morning_start_time', $schedule->morning_start_time)); ?>" required>
               </div>
               <div class="col-md-6 mb-3">
                  <label class="form-label">End Time</label>
                  <input type="time" name="morning_end_time" class="form-control"
                     value="<?php echo e(old('morning_end_time', $schedule->morning_end_time)); ?>" required>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="col-md-6">
      
      <div class="card mb-4">
         <div class="card-header fw-bold">Evening Shift</div>
         <div class="card-body">
            <div class="mb-3">
               <label class="form-label">Location</label>
               <input type="text" name="evening_location" class="form-control"
                  value="<?php echo e(old('evening_location', $schedule->evening_location)); ?>">
            </div>
            <div class="row">
               <div class="col-md-6 mb-3">
                  <label class="form-label">Start Time</label>
                  <input type="time" name="evening_start_time" class="form-control"
                     value="<?php echo e(old('evening_start_time', $schedule->evening_start_time)); ?>">
               </div>
               <div class="col-md-6 mb-3">
                  <label class="form-label">End Time</label>
                  <input type="time" name="evening_end_time" class="form-control"
                     value="<?php echo e(old('evening_end_time', $schedule->evening_end_time)); ?>">
               </div>
            </div>
         </div>
      </div>
   </div>
</div><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/schedules/_form.blade.php ENDPATH**/ ?>