<?php $__env->startSection('title', 'Schedules'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3"> Schedule</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('admin.schedules.index')); ?>"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Schedule</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.create')): ?>
                    <a href="<?php echo e(route('admin.schedules.create')); ?>" class="btn btn-primary btn-sm mb-3">
                        <i class="bi bi-plus-circle"></i> Add Schedule
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.view')): ?>
                <a href="<?php echo e(route('admin.schedules.calendar')); ?>" class="btn btn-sm btn-info mb-3">
                    <i class="bi bi-calendar-event"></i> Calendar View
                </a>
                <?php endif; ?>
            </div>
        </div>


        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body table-responsive">
                <table id="schedulesTable" class="table table-striped table-hover display">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Company</th>
                            <th>Date</th>
                            <th>Morning</th>
                            <th>Evening</th>
                            <th>Fees</th>
                            <th>Status</th>
                            <th width="160">Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th>User</th>
                            <th>Company</th>
                            <th>Date</th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th>Status</th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($schedule->user->name ?? '-'); ?></td>
                                <td><?php echo e($schedule->company->name ?? '-'); ?></td>
                                <td><?php echo e($schedule->schedule_date->format('Y-m-d')); ?></td>
                                <td>
                                    <?php echo e($schedule->morning_location); ?><br>
                                    <?php echo e($schedule->morning_start_time); ?> - <?php echo e($schedule->morning_end_time); ?>

                                </td>
                                <td>
                                    <?php if($schedule->evening_location): ?>
                                        <?php echo e($schedule->evening_location); ?><br>
                                        <?php echo e($schedule->evening_start_time); ?> - <?php echo e($schedule->evening_end_time); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($schedule->fees, 2)); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($schedule->status ? 'success' : 'secondary'); ?>">
                                        <?php echo e($schedule->status ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </td>
                                <td class="d-flex gap-1">
                                    <a href="<?php echo e(route('admin.schedules.show', $schedule)); ?>" class="btn btn-info btn-sm">View</a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.edit')): ?>
                                        <a href="<?php echo e(route('admin.schedules.edit', $schedule)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.delete')): ?>
                                        <form action="<?php echo e(route('admin.schedules.destroy', $schedule)); ?>" method="POST"
                                              onsubmit="return confirm('Are you sure?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center">No schedules found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($schedules->links()); ?>

                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $("#schedulesTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            // Add column filters for User, Company, Date, Status
            this.api().columns([1,2,3,7]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/schedules/index.blade.php ENDPATH**/ ?>