<?php $__env->startSection('title', 'Leads'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Leads</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('dashboard')); ?>"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Leads</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.create')): ?>
                    <a href="<?php echo e(route('admin.leads.create')); ?>" class="btn btn-sm btn-primary mb-3">
                        Add Lead
                    </a>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="mb-3 d-flex align-items-center flex-wrap gap-2">
            <input type="checkbox" id="selectAll" class="me-2"> Select All

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.change_stage')): ?>
            <select id="bulkStageSelect" class="form-select w-auto me-2">
                <option value="">-- Change Stage --</option>
                <?php $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($stg->id); ?>"><?php echo e($stg->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button id="applyBulkStage" class="btn btn-sm btn-primary me-2">Apply Stage</button>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.change_user')): ?>
            <select id="bulkUserSelect" class="form-select w-auto me-2">
                <option value="">-- Change User --</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($usr->id); ?>"><?php echo e($usr->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button id="applyBulkUser" class="btn btn-sm btn-info me-2">Apply User</button>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.delete')): ?>
            <button id="bulkDelete" class="btn btn-sm btn-danger">Delete Selected</button>
            <?php endif; ?>
        </div>

        
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="leadsTable" class="display table table-striped table-hover">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Stage</th>
                                <th>Status</th>
                                <th>Assigned To</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Stage</th>
                                <th>Status</th>
                                <th>User</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><input type="checkbox" class="select-lead" value="<?php echo e($lead->id); ?>"></td>
                                    <td><?php echo e($lead->name); ?></td>
                                    <td><?php echo e($lead->phone); ?></td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($lead->stage->name ?? '-'); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo e(ucfirst($lead->status)); ?></span>
                                    </td>
                                    <td><?php echo e($lead->user->name ?? '-'); ?></td>
                                    <td>
                                        
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.edit')): ?>
                                            <a href="<?php echo e(route('admin.leads.edit', $lead)); ?>" class="btn btn-sm btn-warning">Edit</a>
                                        <?php endif; ?>

                                        
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['leads.view.all', 'leads.view.company', 'leads.view.own'])): ?>
                                            <a href="<?php echo e(route('admin.leads.show', $lead)); ?>" class="btn btn-sm btn-info">View</a>
                                        <?php endif; ?>

                                        
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.delete')): ?>
                                            <form action="<?php echo e(route('admin.leads.destroy', $lead)); ?>" method="POST" style="display:inline-block">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this lead?')">Delete</button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">No leads found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php echo e($leads->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(function () {
    // Initialize DataTable
    var table = $('#leadsTable').DataTable({
        pageLength: 10,
        initComplete: function () {
            this.api().columns([1,2,3,4]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        column.search($(this).val()).draw();
                    });

                column.data().unique().sort().each(function (d) {
                    d = d.replace(/<[^>]*>/g, '');
                    if (d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });

    // Select all checkboxes
    $('#selectAll').on('click', function() {
        $('.select-lead').prop('checked', this.checked);
    });

    // Bulk Stage update
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.change_stage')): ?>
    $('#applyBulkStage').on('click', function() {
        var selectedLeads = $('.select-lead:checked').map(function(){ return $(this).val(); }).get();
        var newStageId = $('#bulkStageSelect').val();

        if(selectedLeads.length === 0){ alert('Select at least one lead.'); return; }
        if(!newStageId){ alert('Select a stage.'); return; }

        $.post("<?php echo e(route('admin.leads.bulk-stage-update')); ?>", {
            _token: "<?php echo e(csrf_token()); ?>",
            lead_ids: selectedLeads,
            new_stage_id: newStageId
        }, function(){ location.reload(); });
    });
    <?php endif; ?>

    // Bulk User update
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.change_user')): ?>
    $('#applyBulkUser').on('click', function() {
        var selectedLeads = $('.select-lead:checked').map(function(){ return $(this).val(); }).get();
        var newUserId = $('#bulkUserSelect').val();

        if(selectedLeads.length === 0){ alert('Select at least one lead.'); return; }
        if(!newUserId){ alert('Select a user.'); return; }

        $.post("<?php echo e(route('admin.leads.bulk-user-update')); ?>", {
            _token: "<?php echo e(csrf_token()); ?>",
            lead_ids: selectedLeads,
            new_user_id: newUserId
        }, function(){ location.reload(); });
    });
    <?php endif; ?>

    // Bulk Delete
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leads.delete')): ?>
    $('#bulkDelete').on('click', function() {
        var selectedLeads = $('.select-lead:checked').map(function(){ return $(this).val(); }).get();
        if(selectedLeads.length === 0){ alert('Select at least one lead.'); return; }
        if(!confirm('Are you sure you want to delete selected leads?')) return;

        $.ajax({
            url: "<?php echo e(route('admin.leads.bulk-delete')); ?>",
            type: 'POST',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                lead_ids: selectedLeads
            },
            success: function(){ location.reload(); }
        });
    });
    <?php endif; ?>
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/leads/index.blade.php ENDPATH**/ ?>