<section>
    <header class="mb-4">
        <h5 class="fw-semibold">Update Password</h5>
        <p class="text-muted">
            Ensure your account is using a long, random password to stay secure.
        </p>
    </header>

    <form method="post" action="<?php echo e(route('password.update')); ?>">
        <?php echo csrf_field(); ?>
        <?php echo method_field('put'); ?>

        
        <div class="mb-3">
            <label for="current_password" class="form-label">
                Current Password
            </label>
            <input
                id="current_password"
                name="current_password"
                type="password"
                class="form-control <?php if($errors->updatePassword->has('current_password')): ?> is-invalid <?php endif; ?>"
                autocomplete="current-password"
            >
            <?php if($errors->updatePassword->has('current_password')): ?>
                <div class="invalid-feedback">
                    <?php echo e($errors->updatePassword->first('current_password')); ?>

                </div>
            <?php endif; ?>
        </div>

        
        <div class="mb-3">
            <label for="password" class="form-label">
                New Password
            </label>
            <input
                id="password"
                name="password"
                type="password"
                class="form-control <?php if($errors->updatePassword->has('password')): ?> is-invalid <?php endif; ?>"
                autocomplete="new-password"
            >
            <?php if($errors->updatePassword->has('password')): ?>
                <div class="invalid-feedback">
                    <?php echo e($errors->updatePassword->first('password')); ?>

                </div>
            <?php endif; ?>
        </div>

        
        <div class="mb-3">
            <label for="password_confirmation" class="form-label">
                Confirm Password
            </label>
            <input
                id="password_confirmation"
                name="password_confirmation"
                type="password"
                class="form-control <?php if($errors->updatePassword->has('password_confirmation')): ?> is-invalid <?php endif; ?>"
                autocomplete="new-password"
            >
            <?php if($errors->updatePassword->has('password_confirmation')): ?>
                <div class="invalid-feedback">
                    <?php echo e($errors->updatePassword->first('password_confirmation')); ?>

                </div>
            <?php endif; ?>
        </div>

        
        <div class="d-flex align-items-center gap-3">
            <button type="submit" class="btn btn-primary">
                Save
            </button>

            <?php if(session('status') === 'password-updated'): ?>
                <span class="text-success">
                    Saved.
                </span>
            <?php endif; ?>
        </div>
    </form>
</section>
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/profile/partials/update-password-form.blade.php ENDPATH**/ ?>