<?php $__env->startSection('title', 'Schedule Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3"> Schedule Details</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('admin.schedules.index')); ?>"><i class="icon-home"></i></a>
                        </li>
                        <li class="separator"><i class="icon-arrow-right"></i></li>
                        <li class="nav-item"><a href="#">Schedule Details</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 ms-auto">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.create')): ?>
                    <a href="<?php echo e(route('admin.schedules.create')); ?>" class="btn btn-primary btn-sm mb-3">
                        <i class="bi bi-plus-circle"></i> Add Schedule
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('schedules.view')): ?>
                    <a href="<?php echo e(route('admin.schedules.calendar')); ?>" class="btn btn-sm btn-info mb-3">
                        <i class="bi bi-calendar-event"></i> Calendar View
                    </a>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="card mb-3">
            <div class="card-body row">
                <div class="col-md-4">
                    <p><strong>User:</strong> <?php echo e($schedule->user->name); ?></p>
                    <p><strong>Company:</strong> <?php echo e($schedule->company->name); ?></p>
                    <p><strong>Status:</strong> 
                        <span class="badge bg-<?php echo e($schedule->status ? 'success' : 'secondary'); ?>">
                            <?php echo e($schedule->status ? 'Active' : 'Inactive'); ?>

                        </span>
                    </p>
                </div>
                <div class="col-md-4">
                    <p><strong>Total Slots:</strong> <?php echo e($slots->count()); ?></p>
                    <p><strong>Fees:</strong> <?php echo e(number_format($schedule->fees, 2)); ?></p>
                    <p><strong>Total Fees:</strong> <?php echo e(number_format($slots->sum('fees'), 2)); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Schedule Date:</strong> <?php echo e($schedule->schedule_date->format('Y-m-d')); ?></p>
                    <p><strong>Per Customer Time:</strong> <?php echo e($schedule->per_customer_time); ?> mins</p>
                    <p><strong>Morning Location:</strong> <?php echo e($schedule->morning_location); ?></p>
                    <p><strong>Evening Location:</strong> <?php echo e($schedule->evening_location); ?></p>
                </div>
            </div>
        </div>

        
        <div class="card">
            <div class="card-body">
                <h5>Slots</h5>
                <div class="table-responsive">
                    <table id="slotsTable" class="table table-striped table-hover display">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Shift</th>
                                <th>Location</th>
                                <th>Start Time</th>
                                <th>End Time</th>
                                <th>Fees</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th>Shift</th>
                                <th>Location</th>
                                <th></th>
                                <th></th>
                                <th>Fees</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $slots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $booking = $slot->booking;
                                    $rowClass = '';
                                    $actionButton = '<a href="'.route('admin.bookings.create', ['slot_id' => $slot->id]).'" class="btn btn-sm btn-success">Book</a>';

                                    if($booking){
                                        switch($booking->status){
                                            case 'pending': $rowClass = 'table-warning'; break;
                                            case 'confirmed': $rowClass = 'table-success'; break;
                                            case 'cancelled': $rowClass = 'table-danger'; break;
                                            case 'completed': $rowClass = 'table-info'; break;
                                        }
                                        $actionButton = '<span class="badge bg-dark text-white">Booked</span>';
                                    }
                                ?>
                                <tr class="<?php echo e($rowClass); ?>">
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e(ucfirst($slot->shift)); ?></td>
                                    <td><?php echo e($slot->location); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($slot->start_time)->format('H:i')); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($slot->end_time)->format('H:i')); ?></td>
                                    <td><?php echo e(number_format($slot->fees, 2)); ?></td>
                                    <td><?php echo $actionButton; ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">No slots found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $("#slotsTable").DataTable({
        pageLength: 10,
        initComplete: function () {
            // Column filters for Shift, Location, Fees
            this.api().columns([1,2,5]).every(function () {
                var column = this;
                var select = $('<select class="form-select form-select-sm"><option value="">All</option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function () {
                        var val = $.fn.dataTable.util.escapeRegex($(this).val());
                        column.search(val ? '^' + val + '$' : '', true, false).draw();
                    });

                column.data().unique().sort().each(function(d) {
                    if(d) select.append('<option value="'+d+'">'+d+'</option>');
                });
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/schedules/show.blade.php ENDPATH**/ ?>