<?php $__env->startSection('content'); ?>
<div class="container">
   <div class="page-inner">
      <div class="row row-demo-grid">
         <div class="col-md-8">
            <div class="page-header">
               <h3 class="fw-bold mb-3">Roles</h3>
               <ul class="breadcrumbs mb-3">
                  <li class="nav-home">
                     <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="icon-home"></i>
                     </a>
                  </li>
                  <li class="separator">
                     <i class="icon-arrow-right"></i>
                  </li>
                  <li class="nav-item">
                     <a href="#">Roles</a>
                  </li>
               </ul>
            </div>
         </div>
         <div class="col-md-4 ms-auto">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage roles')): ?>
            <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-sm btn-primary mb-3">
                Add Role
            </a>
            <?php endif; ?>
         </div>
      </div>

      <?php if(session('success')): ?>
      <div class="alert alert-success">
         <?php echo e(session('success')); ?>

      </div>
      <?php endif; ?>

      <div class="card">
         <div class="card-body">
            <div class="table-responsive">
               <table id="multi-filter-select" class="display table table-striped table-hover">
                  <thead>
                     <tr>
                        <th>Role Name</th>
                        <th>Permissions</th>
                        <th>Actions</th>
                     </tr>
                  </thead>
                  <tfoot>
                     <tr>
                        <th>Role Name</th>
                        <th>Permissions</th>
                        <th></th>
                     </tr>
                  </tfoot>
                  <tbody>
                     <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                     <tr>
                        <td><?php echo e($role->name); ?></td>
                        <td>
                            <?php echo implode(' ', $role->permissions->pluck('name')->map(function($name) {
                                return '<span class="badge badge-pill badge-info">' . $name . '</span>';
                            })->toArray()); ?>

                        </td>
                        <td>
                           
                           <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.edit')): ?>
                              <a href="<?php echo e(route('admin.roles.edit', $role)); ?>" class="btn btn-sm btn-warning mb-1">
                                    Edit
                              </a>
                           <?php endif; ?>

                           
                           <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.delete')): ?>
                              <form action="<?php echo e(route('admin.roles.destroy', $role)); ?>" method="POST" style="display:inline-block">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger mb-1"
                                       onclick="return confirm('Are you sure you want to delete this role?')">
                                       Delete
                                    </button>
                              </form>
                           <?php endif; ?>
                        </td>
                     </tr>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                     <tr>
                        <td colspan="3" class="text-center">No roles found.</td>
                     </tr>
                     <?php endif; ?>
                  </tbody>
               </table>
            </div>
         </div>
      </div>
   </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
   $(document).ready(function () {
       $("#multi-filter-select").DataTable({
           pageLength: 10,
           initComplete: function () {
               this.api().columns([0, 1]).every(function () {
                   var column = this;

                   var select = $('<select class="form-select"><option value="">All</option></select>')
                       .appendTo($(column.footer()).empty())
                       .on("change", function () {
                           var val = $.fn.dataTable.util.escapeRegex($(this).val());
                           column
                               .search(val ? "^" + val + "$" : "", true, false)
                               .draw();
                       });

                   column.data().unique().sort().each(function (d) {
                       if (d) {
                           select.append('<option value="' + d + '">' + d + '</option>');
                       }
                   });
               });
           }
       });
   });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/roles/index.blade.php ENDPATH**/ ?>