<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="page-inner">
        <div class="row row-demo-grid">
            <div class="col-md-8">
                <div class="page-header">
                    <h3 class="fw-bold mb-3">Create Role</h3>
                    <ul class="breadcrumbs mb-3">
                        <li class="nav-home">
                            <a href="<?php echo e(route('dashboard')); ?>">
                                <i class="icon-home"></i>
                            </a>
                        </li>
                        <li class="separator">
                            <i class="icon-arrow-right"></i>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.roles.index')); ?>">Roles</a>
                        </li>
                        <li class="separator">
                            <i class="icon-arrow-right"></i>
                        </li>
                        <li class="nav-item">
                            <a href="#">Create</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 ms-auto">
                <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-sm btn-secondary mb-3">
                    Back to Roles
                </a>
            </div>
        </div>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.roles.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="mb-3">
                        <label class="form-label">Role Name</label>
                        <input type="text" name="name" class="form-control" value="<?php echo e(old('name')); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Permissions</label><br>
                        
                        <?php
                            $groupedPermissions = $permissions->groupBy(function($perm) {
                                return \Illuminate\Support\Str::before($perm->name, '.');
                            });
                        ?>

                        <?php $__currentLoopData = $groupedPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $perms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-2">
                                <h6 class="fw-bold"><?php echo e(ucfirst($group)); ?></h6>
                                <?php $__currentLoopData = $perms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" name="permissions[]" 
                                               value="<?php echo e($permission->name); ?>" id="perm_<?php echo e($permission->id); ?>"
                                               <?php echo e(in_array($permission->name, old('permissions', [])) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="perm_<?php echo e($permission->id); ?>">
                                            <?php echo e(\Illuminate\Support\Str::after($permission->name, '.')); ?>

                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <button type="submit" class="btn btn-success">Create Role</button>
                    <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/roles/create.blade.php ENDPATH**/ ?>