<section>
    <header class="mb-4">
        <h5 class="fw-semibold">Profile Information</h5>
        <p class="text-muted">
            Update your account's profile information, contact info, and social links.
        </p>
    </header>

    
    <form id="send-verification" method="post" action="<?php echo e(route('verification.send')); ?>">
        <?php echo csrf_field(); ?>
    </form>

    <form method="post" action="<?php echo e(route('profile.update')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('patch'); ?>

        
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input
                id="name"
                name="name"
                type="text"
                class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                value="<?php echo e(old('name', $user->name)); ?>"
                required
            >
            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input
                id="email"
                name="email"
                type="email"
                class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                value="<?php echo e(old('email', $user->email)); ?>"
                required
            >
            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

            <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail()): ?>
                <div class="alert alert-warning mt-3">
                    <p class="mb-1">Your email address is unverified.</p>
                    <button type="submit" form="send-verification" class="btn btn-link p-0">
                        Click here to re-send the verification email.
                    </button>
                    <?php if(session('status') === 'verification-link-sent'): ?>
                        <div class="text-success mt-2">
                            A new verification link has been sent to your email address.
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        
        <div class="mb-3">
            <label for="avatar" class="form-label">Avatar</label>
            <input type="file" id="avatar" name="avatar" class="form-control <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
            <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="mb-3">
            <label for="banner" class="form-label">Banner</label>
            <input type="file" id="banner" name="banner" class="form-control <?php $__errorArgs = ['banner'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
            <?php $__errorArgs = ['banner'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div class="mb-3">
            <label for="phone" class="form-label">Phone</label>
            <input id="phone" name="phone" type="text" class="form-control" value="<?php echo e(old('phone', $user->profile->phone ?? '')); ?>">
        </div>

        <div class="mb-3">
            <label for="website" class="form-label">Website</label>
            <input id="website" name="website" type="url" class="form-control" value="<?php echo e(old('website', $user->profile->website ?? '')); ?>">
        </div>

        
        <div class="row mb-3">
            <div class="col">
                <label for="position" class="form-label">Position</label>
                <input id="position" name="position" type="text" class="form-control" value="<?php echo e(old('position', $user->profile->position ?? '')); ?>">
            </div>
            <div class="col">
                <label for="department" class="form-label">Department</label>
                <input id="department" name="department" type="text" class="form-control" value="<?php echo e(old('department', $user->profile->department ?? '')); ?>">
            </div>
        </div>

        
        <div class="mb-3">
            <label for="linkedin" class="form-label">LinkedIn</label>
            <input id="linkedin" name="linkedin" type="url" class="form-control" value="<?php echo e(old('linkedin', $user->profile->linkedin ?? '')); ?>">
        </div>
        <div class="mb-3">
            <label for="facebook" class="form-label">Facebook</label>
            <input id="facebook" name="facebook" type="url" class="form-control" value="<?php echo e(old('facebook', $user->profile->facebook ?? '')); ?>">
        </div>
        <div class="mb-3">
            <label for="instagram" class="form-label">Instagram</label>
            <input id="instagram" name="instagram" type="url" class="form-control" value="<?php echo e(old('instagram', $user->profile->instagram ?? '')); ?>">
        </div>
        <div class="mb-3">
            <label for="twitter" class="form-label">Twitter</label>
            <input id="twitter" name="twitter" type="url" class="form-control" value="<?php echo e(old('twitter', $user->profile->twitter ?? '')); ?>">
        </div>

        
        <div class="row mb-3">
            <div class="col">
                <label for="languages" class="form-label">Languages (comma separated)</label>
                <input id="languages" name="languages" type="text" class="form-control" value="<?php echo e(old('languages', isset($user->profile->languages) ? implode(',', $user->profile->languages) : '')); ?>">
            </div>
            <div class="col">
                <label for="locations" class="form-label">Locations (comma separated)</label>
                <input id="locations" name="locations" type="text" class="form-control" value="<?php echo e(old('locations', isset($user->profile->locations) ? implode(',', $user->profile->locations) : '')); ?>">
            </div>
        </div>

        
        <div class="mb-3">
            <label for="about" class="form-label">About / Bio</label>
            <textarea id="about" name="about" class="form-control" rows="4"><?php echo e(old('about', $user->profile->about ?? '')); ?></textarea>
        </div>

        
        <div class="d-flex align-items-center gap-3">
            <button type="submit" class="btn btn-primary">Save</button>

            <?php if(session('status') === 'profile-updated'): ?>
                <span class="text-success">Saved.</span>
            <?php endif; ?>
        </div>
    </form>
</section>
<?php /**PATH /Users/macintosh/Downloads/IMP Office Files/New Dashboard/dashboard/resources/views/profile/partials/update-profile-information-form.blade.php ENDPATH**/ ?>